<?php 
/**
 * Single Product Rating
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/rating.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

if ( get_option( 'woocommerce_enable_review_rating' ) === 'no' ) {
	return;
}

$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average      = $product->get_average_rating();

if ( $rating_count > 0 ) : ?>

	<div class="woocommerce-product-rating" itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">
		<?php
			$automatic_rate_ave = "";
			if (($average < 3 && $average > 0)) {
				$automatic_rate_ave = "rate_red";
			}
			elseif (($average < 4 && $average >= 3)) {
				$automatic_rate_ave = "rate_yellow";
			}
			elseif (($average <= 5 && $average >= 4)) {
				$automatic_rate_ave = "rate_blue";
			}
			if ( $average != 0 ){
				echo '<div class="product-title-has-rate">';
				?>
				<span class="rating-product <?php echo esc_attr($automatic_rate_ave); ?>">
					<i class="automaticicon-rate"></i><?php echo esc_html($average); ?>
				</span>
				<?php
				echo '</div>';
			}
		?>
	</div>

<?php endif; ?>
